import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:araucaria_sapling_bonemeal', {
        onPlayerInteract({ block, player }) {
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                const chance = Math.random();
                if (chance <= 1 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree0 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 2 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree1 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 3 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree2 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 4 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree3 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 5 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree4 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 6 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree5 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 7 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree6 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                } else if (chance <= 8 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree7 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else if (chance <= 9 / 10) {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`structure load mystructure:araucaria_tree8 ${x - 5} ${y} ${z - 5}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                }
                else {
                    const { x, y, z } = block.location
                    block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                    block.dimension.playSound('item.bone_meal.use', block.location)
                }
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:araucaria_sapling_grow', {
        onTick({ block }) {
            const chance = Math.random();
            if (chance <= 1 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree0 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 2 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree1 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 3 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree2 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 4 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree3 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 5 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree4 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 6 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree5 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 7 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree6 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            } else if (chance <= 8 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree7 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else if (chance <= 9 / 10) {
                const { x, y, z } = block.location
                block.dimension.runCommand(`structure load mystructure:araucaria_tree8 ${x - 5} ${y} ${z - 5}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }
            else {
                const { x, y, z } = block.location
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
                block.dimension.playSound('item.bone_meal.use', block.location)
            }
        }
    })
})